/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.ackandget;

import com.floragunn.searchguard.user.User;
import com.floragunn.signals.NoSuchActionException;
import com.floragunn.signals.NoSuchWatchOnThisNodeException;
import com.floragunn.signals.NotAcknowledgeableException;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsTenant;
import com.floragunn.signals.actions.watch.ackandget.AckAndGetWatchRequest;
import com.floragunn.signals.actions.watch.ackandget.AckAndGetWatchResponse;
import com.floragunn.signals.actions.watch.ackandget.Acknowledgement;
import com.floragunn.signals.watch.common.Ack;
import com.floragunn.signals.watch.state.ActionState;
import com.floragunn.signals.watch.state.WatchState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportAckAndGetWatchAction
extends TransportNodesAction<AckAndGetWatchRequest, AckAndGetWatchResponse, NodeRequest, NodeResponse> {
    private static final Logger log = LogManager.getLogger(TransportAckAndGetWatchAction.class);
    private final Signals signals;
    private final ThreadPool threadPool;

    @Inject
    public TransportAckAndGetWatchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Signals signals) {
        super("cluster:admin:searchguard:tenant:signals:watch/ack_and_get", threadPool, clusterService, transportService, actionFilters, AckAndGetWatchRequest::new, NodeRequest::new, "management", NodeResponse.class);
        this.signals = signals;
        this.threadPool = threadPool;
    }

    protected AckAndGetWatchResponse newResponse(AckAndGetWatchRequest request, List<NodeResponse> responses, List<FailedNodeException> failures) {
        return new AckAndGetWatchResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected NodeResponse nodeOperation(NodeRequest request) {
        try {
            DiscoveryNode localNode = this.clusterService.localNode();
            ThreadContext threadContext = this.threadPool.getThreadContext();
            User user = (User)threadContext.getTransient("_sg_user");
            if (user == null) {
                return new NodeResponse(localNode, AckAndGetWatchResponse.Status.UNAUTHORIZED, "Request did not contain user");
            }
            SignalsTenant signalsTenant = this.signals.getTenant(user);
            if (signalsTenant == null) {
                return new NodeResponse(localNode, AckAndGetWatchResponse.Status.NO_SUCH_TENANT, "No such tenant: " + user.getRequestedTenant());
            }
            if (request.request.getWatchId() == null) {
                throw new IllegalArgumentException("request.watchId is null");
            }
            if (!signalsTenant.runsWatchLocally(request.request.getWatchId())) {
                return new NodeResponse(localNode, AckAndGetWatchResponse.Status.NO_SUCH_WATCH, "This node does not run " + request.request.getWatchId());
            }
            if (request.request.getActionId() != null) {
                String actionId = request.request.getActionId();
                if (signalsTenant.getWatchState(request.request.getWatchId()).isActionMissing(actionId)) {
                    String message = String.format("Watch %s does not contain action %s", request.request.getWatchId(), actionId);
                    return new NodeResponse(localNode, AckAndGetWatchResponse.Status.NO_SUCH_ACTION, message);
                }
                try {
                    if (request.request.isAck()) {
                        WatchState watchState = signalsTenant.ack(request.request.getWatchId(), actionId, user);
                        ActionState actionState = watchState.getActionState(actionId);
                        Ack acked = actionState.getAcked();
                        Acknowledgement acknowledgement = new Acknowledgement(acked.getOn(), acked.getBy(), actionId);
                        return new NodeResponse(localNode, AckAndGetWatchResponse.Status.SUCCESS, "Acknowledged", acknowledgement);
                    }
                    signalsTenant.unack(request.request.getWatchId(), actionId, user);
                    List<String> unackedActionIds = Collections.singletonList(actionId);
                    return new NodeResponse(localNode, AckAndGetWatchResponse.Status.SUCCESS, "Un-acknowledged", unackedActionIds);
                }
                catch (IllegalStateException e) {
                    return new NodeResponse(localNode, AckAndGetWatchResponse.Status.ILLEGAL_STATE, e.getMessage());
                }
            }
            if (request.request.isAck()) {
                Map<String, Ack> ackedActions = signalsTenant.ack(request.request.getWatchId(), user);
                if (ackedActions.size() == 0) {
                    return new NodeResponse(localNode, AckAndGetWatchResponse.Status.ILLEGAL_STATE, "No actions are in an acknowlegable state");
                }
                String message = "Acknowledged: " + new ArrayList<String>(ackedActions.keySet());
                Acknowledgement[] acknowledgements = (Acknowledgement[])ackedActions.entrySet().stream().map(entry -> new Acknowledgement(((Ack)entry.getValue()).getOn(), ((Ack)entry.getValue()).getBy(), (String)entry.getKey())).toArray(Acknowledgement[]::new);
                return new NodeResponse(localNode, AckAndGetWatchResponse.Status.SUCCESS, message, acknowledgements);
            }
            List<String> unackedActions = signalsTenant.unack(request.request.getWatchId(), user);
            if (unackedActions.size() == 0) {
                return new NodeResponse(localNode, AckAndGetWatchResponse.Status.ILLEGAL_STATE, "No actions are in an un-acknowlegable state");
            }
            return new NodeResponse(localNode, AckAndGetWatchResponse.Status.SUCCESS, "Un-acknowledged: " + unackedActions, unackedActions);
        }
        catch (NoSuchWatchOnThisNodeException e) {
            return new NodeResponse(this.clusterService.localNode(), AckAndGetWatchResponse.Status.ILLEGAL_STATE, "The watch has not been initialized yet");
        }
        catch (NoSuchActionException e) {
            return new NodeResponse(this.clusterService.localNode(), AckAndGetWatchResponse.Status.NO_SUCH_ACTION, e.getMessage());
        }
        catch (NotAcknowledgeableException e) {
            return new NodeResponse(this.clusterService.localNode(), AckAndGetWatchResponse.Status.NOT_ACKNOWLEDGEABLE, e.getMessage());
        }
        catch (Exception e) {
            log.error("Error while acknowledging " + (Object)((Object)request.request), (Throwable)e);
            return new NodeResponse(this.clusterService.localNode(), AckAndGetWatchResponse.Status.EXCEPTION, e.toString());
        }
    }

    protected NodeRequest newNodeRequest(AckAndGetWatchRequest request) {
        return new NodeRequest(request);
    }

    protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeResponse(in);
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private AckAndGetWatchResponse.Status status;
        private String message;
        private Acknowledgement[] acknowledgements;
        private String[] unackedActionIds;

        public NodeResponse(DiscoveryNode node, AckAndGetWatchResponse.Status status, String message, Acknowledgement[] acknowledgements) {
            super(node);
            this.status = status;
            this.message = message;
            this.acknowledgements = acknowledgements;
            this.unackedActionIds = new String[0];
        }

        public NodeResponse(DiscoveryNode node, AckAndGetWatchResponse.Status status, String message, List<String> unackedActionIds) {
            super(node);
            this.status = status;
            this.message = message;
            this.acknowledgements = new Acknowledgement[0];
            this.unackedActionIds = (String[])Objects.requireNonNull(unackedActionIds, "Unacked action ids are required.").stream().toArray(String[]::new);
        }

        NodeResponse(DiscoveryNode node, AckAndGetWatchResponse.Status status, String message, Acknowledgement acknowledgement) {
            super(node);
            this.status = status;
            this.message = message;
            this.acknowledgements = new Acknowledgement[]{acknowledgement};
            this.unackedActionIds = new String[0];
        }

        public NodeResponse(DiscoveryNode node, AckAndGetWatchResponse.Status status, String message) {
            this(node, status, message, new Acknowledgement[0]);
        }

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.status = (AckAndGetWatchResponse.Status)in.readEnum(AckAndGetWatchResponse.Status.class);
            this.message = in.readOptionalString();
            this.acknowledgements = (Acknowledgement[])in.readArray((Writeable.Reader)new Acknowledgement.AcknowledgementReader(), Acknowledgement[]::new);
            this.unackedActionIds = (String[])in.readArray(stream -> stream.readString(), String[]::new);
        }

        public static NodeResponse readNodeResponse(StreamInput in) throws IOException {
            NodeResponse result = new NodeResponse(in);
            return result;
        }

        public String getMessage() {
            return this.message;
        }

        public Acknowledgement[] getAcknowledgements() {
            return this.acknowledgements;
        }

        public String[] getUnackedActionIds() {
            return this.unackedActionIds;
        }

        public AckAndGetWatchResponse.Status getStatus() {
            return this.status;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeEnum((Enum)this.status);
            out.writeOptionalString(this.message);
            out.writeArray((Writeable.Writer)new Acknowledgement.AcknowledgementWriter(), (Object[])this.acknowledgements);
            out.writeArray((stream, element) -> stream.writeString(element), (Object[])this.unackedActionIds);
        }

        public String toString() {
            return "NodeResponse [status=" + (Object)((Object)this.status) + ", message=" + this.message + "]";
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        AckAndGetWatchRequest request;

        public NodeRequest() {
        }

        public NodeRequest(AckAndGetWatchRequest request) {
            this.request = request;
        }

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new AckAndGetWatchRequest(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

